unit GraphXYv51;
// ===========================================================================
(*
    5.1  25.05.2015
            .
        TGraphArr.
   // ------------------------------------------------------------------------
           TGraphXY 
      Mouse.
   // ------------------------------------------------------------------------
   :
   GraphP := TGraphXY.Create(PanelP);    //    
   GraphP.OnMouseDown := MDown;          //  
   // ------------------------------------------------------------------------
   //   
   procedure TForm1.MDown(Sender: TObject; Button: TMouseButton;
                          Shift: TShiftState; X, Y: Integer);
   var Ind    : integer;
   begin
     with GraphP //    
     do begin
        //  X      
        // ArrXY -     
        Ind := XPixToArrInd(X, ArrXY);
        if (Ind >= 0)
        then begin
          EditX2.Text := 'X : '    + FloatToStr(ArrXY[Ind].X);
          EditY2.Text := 'F(X) : ' + FloatToStr(ArrXY[Ind].Y);
        end;
     end;
   end;
   // ------------------------------------------------------------------------
   
    5.1 ( 25.05.2015)
     1. FindOptimalScale.   
             X  Y
     2. CalcRangeAndScaleY/   fYMax = fYMin
     3.      
*)
// ===========================================================================
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Dialogs, StdCtrls, ExtCtrls, StrUtils, Math, JPEG;

//       
type TPointXY = record
   X : extended;
   Y : extended;
end;

//          
type TGraphArr   = array of TPointXY;

//     XY -
type
   TGraphXY = class(TObject)
   private
     // ==================================
     fPanel     : TPanel;       //   
     // ==================================
     //   
     WImg       : TImage;       //  Image
     BevelWImg  : TBevel;       //   Image
     StTxtImg   : TStaticText;  //   
     LabelImg   : TLabel;       //   Image
     // ==================================
     fOnMouseMove : TMouseMoveEvent;
     fOnMouseDown : TMouseEvent;
     fOnMouseUp   : TMouseEvent;
     fEnabled     : boolean;    //  
     // ----------------------------------
     fRulEn      : boolean;     //    
     fRulMode    : boolean;     //    -
     fRulMov     : boolean;     //     
     fRulColor   : TColor;      //   
     fSavPen     : record       //    Pen
                      Mode  : TPenMode;
                      Style : TPenStyle;
                      Color : TColor;
                   end;
     fRulOn      : boolean;     //   
     fXRuler     : integer;     //     
     // ==================================
     fGraphTitul : string;      //   
     // ==================================
     //   WImg
     fWImgColor  : TColor;      //   
     fWImgFont   : TFont ;      //  font-a
     // ==================================
     //  
     fNumXCrid   : word;        //     
     fNumYCrid   : word;        //     Y
     fGridColor  : TColor;      //   
     // ==================================
     //   
     fArrXY      : TGraphArr;   //    
     fXMin       : extended;    // X - Min  
     fXMax       : extended;    // X - Max  
     fYMin       : extended;    // Y - Min  
     fYMax       : extended;    // Y - Max  
     // ==================================
     //   
     fXRMin      : extended;    // X - Min   
     fXRMax      : extended;    // X - Max   
     fYRMin      : extended;    // Y - Min   
     fYRMax      : extended;    // Y - Max   
     fXLRange    : extended;    //  X -    
     fYLRange    : extended;    //  Y -    
     fBaseX      : extended;    //    X
     fBaseY      : extended;    //    
     fScaleX     : extended;    //     X
     fScaleY     : extended;    //     Y
     // ==================================
     //   
     fAxesToZero : boolean;     //     
     fYforAxesX  : extended;    // Y -   "X"
     fXforAxesY  : extended;    // X -   "Y"
     fAxesColor  : TColor;      //     
     fPicAxesX   : string;      // Format-    X
     fPicAxesY   : string;      // Format-    Y
     // ==================================
     //     (   5.1)
     fRulFontNm  : string;      //     
     fRulFontSz  : integer;     //     
     // ==================================
     //   
     //     Image
     procedure MouseMove(Sender: TObject; Shift: TShiftState;
                         X, Y: Integer);
     procedure MouseDown(Sender: TObject; Button: TMouseButton;
                         Shift: TShiftState; X, Y: Integer);
     procedure MouseUp(Sender: TObject; Button: TMouseButton;
                         Shift: TShiftState; X, Y: Integer);
     // ----------------------------------
     //   
     procedure SavePen();
     //   
     procedure RestorePen();
     //      
     procedure SetRulMode();
     //     X
     procedure ShowRuler(X : integer);
     //  
     procedure HideRuler();
     //  
     procedure MoveRuler(X : integer);
     //        
     procedure ShowArrPoint(XPix : integer);
     // ==================================
     //   
     //       Y
     procedure ShowHGridAndAxesY();
     //  X -       X
     procedure CalcRangeAndScaleX();
     //       X
     procedure ShowHGridAndAxesX();
     //  Y -       Y
     procedure CalcRangeAndScaleY();
     //      
     procedure CalculateScale();
     //  X  Y      (Left)   (Top)
     function XtoL(X : extended): longint;
     function YtoT(Y : extended): longint;
     //        (RqLeft, RqTop)
     procedure SubscriptPointLT(RqLeft, RqTop : longint; RqColor : TColor; RqText : string);
     //     ( RqY)
     //    ( RqX) 
     procedure ShowHLine(RqY : extended; RqColor : TColor; RqText : string);
     procedure ShowVLine(RqX : extended; RqColor : TColor; RqText : string);
     //   
     procedure ShowGridLine();
     //    
     procedure EraseAreaXY();
     //      GraphXY
     procedure PrepareAreaXY();
     // ==================================
     //  / 
     procedure OpenGraphXY(RqPanel: TPanel);
     procedure CloseGraphXY();
     // ==================================
     //    
     procedure SetRulerEnabled (RulEn : boolean);
     procedure SetGraphTitul (GraphTitul : string);
     procedure SetImgBackGroundColor (BackGroundColor : TColor);
     procedure SetGridColor (GridColor : TColor);
     procedure SetAxesColor (AxesColor : TColor);
     procedure SetPicAxesX (PicAxesX : string);
     procedure SetPicAxesY (PicAxesY : string);

   public
     // ==================================
     //   
     // ==================================
     property OnMouseMove  : TMouseMoveEvent read fOnMouseMove write fOnMouseMove;
     property OnMouseDown  : TMouseEvent read fOnMouseDown write fOnMouseDown;
     property OnMouseUp    : TMouseEvent read fOnMouseUp write fOnMouseUp;
     //     WImg
     property Enabled      : boolean read fEnabled write fEnabled;
     //   RulerEnabled
     property RulerEnabled : boolean read fRulEn write SetRulerEnabled;
     //   
     property RulColor     : TColor read fRulColor write fRulColor;
     // ==================================
     //   
     // ==================================
     //       
     property ArrXY : TGraphArr read fArrXY;
     //    
     property GraphTitul : string read fGraphTitul write SetGraphTitul;
     //   
     property BackGroundColor : TColor read fWImgColor write SetImgBackGroundColor;
     //     
     property GridColor : TColor read fGridColor write SetGridColor;
     //   
     property AxesColor : TColor read fAxesColor write SetAxesColor;
     //   ( '%8.4f')    
     property PicAxesX : string read fPicAxesX write SetPicAxesX;
     //   ( '%2.1e')    Y
     property PicAxesY : string read fPicAxesY write SetPicAxesY;
     //     
     property RulFontNm : string read fRulFontNm write fRulFontNm;
     //     
     property RulFontSz  : integer read fRulFontSz write fRulFontSz;
     // ==================================
     //   
     // ==================================
     //   
     constructor Create(RqPanel: TPanel);
     procedure Free();
     // ==================================
     //   
     // ==================================
     //  X      
     function XPixToArrInd (XPix    : integer;
                            RqArrXY : TGraphArr) : integer;
     //   /   X  Y,  
     //        
     procedure SetScaleXY (RqScaleX,  RqScaleY : extended);
     //       
     procedure SetMinMaxXY (RqXMin, RqXMax, RqYMin, RqYMax: extended);
     //        
     procedure FindOptimalScale(RqArrXY : TGraphArr);
     //       
     procedure ShowGraphXY (RqArrXY : TGraphArr; RqColor : TColor);
     //          X  Y
     procedure PaintGraphXY (RqArrXY : TGraphArr; RqColor : TColor);
     //       (RqX, RqY)
     procedure SubscriptPointXY(RqX, RqY : extended; RqColor : TColor; RqText : string);
     //   (  )      (RqX, RqY)
     procedure PaintPointXY(RqX, RqY : extended; RqColor : TColor; RqRadius : byte);
     //    X  Y -    
     procedure VectotToGraphXY(XB, YB, XE, YE : extended; RqColor : TColor);
     //    ,    
     procedure FullEraseAreaXY();
     //     . (RqGFormat: 'J' - jpg   'B' -bmp)
     procedure SaveGraphXY(RqFullFileName : string; RqGFormat : char);
end;

// ===========================================================================
// ===========================================================================
implementation
// ===========================================================================
// ===========================================================================

const
   //    WImg  
   Border1Up    = 30;
   Border1Down  = 6;
   Border1Left  = 6;
   Border1Right = 6;
   //   WImg  
   MinWidth     = 50;
   MinHeight    = 30;
   //      
   LabelTop     = 6;


// ===========================================================================
//
//     GraphXY
//
// ===========================================================================

// ===========================================================================
//        
//  (   5.0)
// ===========================================================================
// ---------------------------------------------------------------------------
// 22.09.2014
//  
procedure TGraphXY.MoveRuler(X : integer);
begin
  //      
  if not fRulEn then Exit;
  //    
  if fXRuler = X then Exit;
  //  
  SavePen();
  //  ,   ,  
  if not fRulMode then SetRulMode();
  //    
  if fRulOn
  then begin
     //     
     with WImg.Canvas do
     begin
       //  
       MoveTo (fXRuler, 0);
       LineTo (fXRuler, WImg.Height);
     end;
  end;
  fXRuler := X;
  with WImg.Canvas do
  begin
     //     
     MoveTo (fXRuler, 0);
     LineTo (fXRuler, WImg.Height);
  end;
  RestorePen();
  ShowArrPoint(X);
end;
// ---------------------------------------------------------------------------
// 22.09.2014
procedure TGraphXY.MouseMove(Sender: TObject; Shift: TShiftState;
                             X, Y: Integer);
begin
   //   
   if fEnabled
   then begin
      //      
      if fRulEn and Assigned (WImg) and fRulMov
      then MoveRuler(X);
      //   
      if Assigned (WImg) and Assigned (fOnMouseMove)
      then fOnMouseMove(Sender, Shift, X, Y);
   end;
end;
// ---------------------------------------------------------------------------
// 22.09.2014
//     X
procedure TGraphXY.ShowRuler(X : integer);
begin
  //      
  if not fRulEn then Exit;
  //     
  if not fRulOn
  then begin
    SavePen();
    //    
    if not fRulMode then SetRulMode();
    with WImg.Canvas do
    begin
      fXRuler := X;
      //  
      MoveTo (fXRuler, 0);
      LineTo (fXRuler, WImg.Height);
      fRulOn := True;
    end;
    //    (   )
    RestorePen();
    ShowArrPoint(X);
  end;
end;
// ---------------------------------------------------------------------------
// 22.09.2014
procedure TGraphXY.MouseDown(Sender: TObject; Button: TMouseButton;
                             Shift: TShiftState; X, Y: Integer);
begin
   //   
   if fEnabled
   then begin
      //      
      if fRulEn and Assigned (WImg)
      then begin
          ShowRuler(X);
          fRulMov := True;
      end;
      //   
      if Assigned (WImg) and Assigned (fOnMouseMove)
      then fOnMouseDown(Sender, Button, Shift, X, Y);
   end;
end;
// ---------------------------------------------------------------------------
// 22.09.2014
procedure TGraphXY.MouseUp(Sender: TObject; Button: TMouseButton;
                           Shift: TShiftState; X, Y: Integer);
begin
   //   
   if fEnabled
   then begin
      //      
      if fRulEn and Assigned (WImg)
      then begin
          RestorePen();
          fRulMov := False;
          ShowArrPoint(X);
      end;
      //   
      if Assigned (WImg) and Assigned (fOnMouseUp)
      then fOnMouseUp(Sender, Button, Shift, X, Y);
   end;
end;
// ---------------------------------------------------------------------------
// 22.09.2014
//   
procedure TGraphXY.SavePen();
begin
  with WImg.Canvas do
  begin
    fSavPen.Mode  := Pen.Mode;
    fSavPen.Style := Pen.Style;
    fSavPen.Color := Pen.Color;
  end;
end;
// ---------------------------------------------------------------------------
// 22.09.2014
//   
procedure TGraphXY.RestorePen();
begin
  with WImg.Canvas do
  begin
    Pen.Mode :=  fSavPen.Mode;
    Pen.Style := fSavPen.Style;
    Pen.Color := fSavPen.Color;
  end;
  //    
  fRulMode := False;
end;
// ---------------------------------------------------------------------------
// 22.09.2014
//        
procedure TGraphXY.SetRulMode();
begin
  //      
  if not fRulEn then Exit;
  // 
  with WImg.Canvas do
  begin
      Pen.Mode  := pmNotXOR;
      Pen.Color := fRulColor;
      Pen.Width := 1;
      Pen.Style := psSolid;
  end;
  //    
  fRulMode := True;
end;
// ---------------------------------------------------------------------------
// 22.09.2014
//  
procedure TGraphXY.HideRuler();
begin
   //   
  if fRulOn and Assigned(WImg)
  then begin
    //    
    if not fRulMode then SetRulMode();
    //  
    with WImg.Canvas do
    begin
      MoveTo (fXRuler, 0);
      LineTo (fXRuler, WImg.Height);
      fRulOn := False;
    end;
    //    (   )
    RestorePen();
    //      
    LabelImg.Caption := fGraphTitul;
  end;
end;
// ---------------------------------------------------------------------------
// 22.09.2014
//   RulerEnabled
procedure TGraphXY.SetRulerEnabled (RulEn : boolean);
begin
   if RulEn
   then fRulEn := True
   else begin
      HideRuler();      //  
      fRulEn := False;
   end;
end;

// ---------------------------------------------------------------------------
//  X      
// 22.09.2014 ()
function TGraphXY.XPixToArrInd (XPix    : integer;
                                RqArrXY : TGraphArr) : integer;
begin
  Result := -1;
  if (XPix >= 0) and (Length(RqArrXY) > 1)
  then begin
    Result := Round(Int((Length(RqArrXY) / WImg.Picture.Bitmap.Width) * XPix));
    if Result > High(RqArrXY) then Result := High(RqArrXY);
  end;
end;

// ---------------------------------------------------------------------------
//        
// 22.09.2014
procedure TGraphXY.ShowArrPoint(XPix : integer);
var Ind  : integer;
    WStr : string;
begin
  if Length(fArrXY) > 1
  then begin
    LabelImg.Font.Name := fRulFontNm;    //     
    LabelImg.Font.Size := fRulFontSz;    //     
    //      
    Ind := XPixToArrInd(XPix, fArrXY);
    if (Ind >= 0)
    then begin
       WStr := '  ( X = ' + FloatToStr(fArrXY[Ind].X)
             + '; Y = ' + FloatToStr(fArrXY[Ind].Y) + ' )';
       //      
       LabelImg.Caption := fGraphTitul + WStr;
    end
    else LabelImg.Caption := fGraphTitul;
  end;
end;

// ===========================================================================
//      GraphXY
//  (   3.5)
// ===========================================================================
// ---------------------------------------------------------------------------
// 25.05.2013
//  X      (Left)
function TGraphXY.XtoL(X : extended): longint;
begin
 Result:= 0;
 if fScaleX > 0
 then begin
    Result := Round(fScaleX * (X - fXRMin));
 end;
end;
// ---------------------------------------------------------------------------
// 25.05.2013
//  Y      (Top)
function TGraphXY.YtoT(Y : extended): longint;
begin
 Result:= 0;
 if fScaleY > 0
 then begin
    Result := (WImg.Height - 1) - Round(fScaleY * (Y - fYRMin));
 end;
end;
// ---------------------------------------------------------------------------
// 25.05.2013
//        (RqLeft, RqTop)
procedure TGraphXY.SubscriptPointLT(RqLeft, RqTop : longint; RqColor : TColor; RqText : string);
const LOffs = 2;
      TOffs = 2;
var   SaveColor  : TColor;
begin
  with WImg.Canvas do
  begin
     if RqText <> ''
     then begin
       //   
       if (RqLeft + TextWidth(RqText)  + LOffs <= WImg.Width) and
          (RqTop + TextHeight(RqText) + TOffs <= WImg.Height)
       then begin
          //      WImg
          SaveColor  := Font.Color;
          Font.Color := RqColor;
          //  
          TextOut(RqLeft + LOffs, RqTop + TOffs, RqText);
          Font.Color := SaveColor;
       end;
     end;
  end;  {of with WImg.Canvas}
end; {of procedure SubscriptPoint}
// ---------------------------------------------------------------------------
// 25.05.2013
//      (   )
procedure TGraphXY.ShowHLine(RqY : extended; RqColor : TColor; RqText : string);
const LOffs = 8;
var   WPenL, WPenT : longint;
      SavePnColor  : TColor;
begin
  with WImg.Canvas do
  begin
    //  
    SavePnColor := Pen.Color;
    Pen.Color   := RqColor;
    WPenL:= 0;
    WPenT:= YtoT(RqY);
    MoveTo(WPenL,WPenT);
    WPenL:= WImg.Width;
    LineTo(WPenL,WPenT);
    //  
    if RqText <> ''
    then begin
        WPenL:= XtoL(fXforAxesY);   // X -   "Y"
        //    
        Pen.Color   := Font.Color;
        MoveTo(WPenL - 3, WPenT);
        LineTo(WPenL + 3, WPenT);
        //   
        if (WPenL +  TextWidth(RqText) + LOffs) >  WImg.Width
        then begin
          //       Y
          WPenL := WPenL -  TextWidth(RqText) - LOffs;
        end
        else begin
          //       Y
          WPenL := WPenL + LOffs;
        end;
        WPenT:= YtoT(RqY);
        SubscriptPointLT(WPenL, WPenT, clBlack, RqText);
    end;
    Pen.Color := SavePnColor;
  end; {of with WImg.Canvas}
end; {procedure ShowHLine}
// ---------------------------------------------------------------------------
// 25.05.2013
//      (   )
procedure TGraphXY.ShowVLine(RqX : extended; RqColor : TColor; RqText : string);
const TOffs = 4;
var   WPenL, WPenT : longint;
      SavePnColor  : TColor;
begin
  with WImg.Canvas do
  begin
     //  
     SavePnColor := Pen.Color;
     Pen.Color   := RqColor;
     WPenT:= 0;
     WPenL:= XtoL(RqX);
     MoveTo(WPenL,WPenT);
     WPenT:= WImg.Height;
     LineTo(WPenL,WPenT);
     Pen.Color := SavePnColor;
     //   
     if RqText <> ''
     then begin
        WPenT:= YtoT(fYforAxesX);  // Y -   "X"
        //    
        Pen.Color   := Font.Color;
        MoveTo(WPenL, WPenT - 3);
        LineTo(WPenL, WPenT + 3);
        //   
        if (WPenT +  TextHeight(RqText) + TOffs) >  WImg.Height
        then begin
           //     
           WPenT := WPenT - TextHeight(RqText) - TOffs;
        end
        else begin
           //     
           WPenT := WPenT + TOffs;
        end;
        WPenL:= XtoL(RqX);
        SubscriptPointLT(WPenL, WPenT, clBlack, RqText);
     end;
     Pen.Color := SavePnColor;
  end;  {of with WImg.Canvas}
end; {of procedure ShowVLine}
// ---------------------------------------------------------------------------
// 25.05.2013
//       Y
procedure TGraphXY.ShowHGridAndAxesY();
var SStep, SNext  : extended;
    WStr : string;
begin
    if fXLRange > 0
    then begin
       //      
       SStep := fXLRange / fNumXCrid;
       //        Y
       SNext := fXforAxesY - SStep;
       while SNext > fXRMin
       do begin
          WStr:= Format(fPicAxesX, [SNext]);
          ShowVLine(SNext, fGridColor, WStr);
          SNext := SNext - SStep;
       end;
       //        Y
       SNext := fXforAxesY + SStep;
       while SNext < fXRMax
       do begin
          WStr:= Format(fPicAxesX, [SNext]);
          ShowVLine(SNext, fGridColor, WStr);
          SNext := SNext + SStep;
       end;
       //    "X"
       ShowVLine(fXforAxesY, fAxesColor, '');
    end
    else begin
       ShowMessage('TGraphXY :      X');
    end;
end;
// ---------------------------------------------------------------------------
// 25.05.2013
//       X
procedure TGraphXY.ShowHGridAndAxesX();
var SStep, SNext  : extended;
    WStr : string;
begin
    if fYLRange > 0
    then begin
       //      
       SStep := fYLRange / fNumYCrid;
       //      
       SNext := fYforAxesX - SStep;
       while SNext > fYRMin
       do begin
          WStr:= Format(fPicAxesY, [SNext]);
          ShowHLine(SNext, fGridColor, WStr);
          SNext := SNext - SStep;
       end;
       //      
       SNext := fYforAxesX + SStep;
       while SNext < fYRMax
       do begin
          WStr:= Format(fPicAxesY, [SNext]);
          ShowHLine(SNext, fGridColor, WStr);
          SNext := SNext + SStep;
       end;
       //    "X"
       ShowHLine(fYforAxesX, fAxesColor, '');
    end
    else begin
       ShowMessage('TGraphXY :      Y');
    end;
end;
// ---------------------------------------------------------------------------
// 25.05.2013 // 22.09.2014 ()
//          X  Y
procedure TGraphXY.PaintGraphXY (RqArrXY : TGraphArr; RqColor : TColor);
var Ind, IndB, IndE : integer;
    WPenX, WPenY    : longint;
begin
  //  
  HideRuler();
  if Assigned(RqArrXY)
  then begin
    //      
    fArrXY := RqArrXY;
    if (fScaleX > 0) and (fScaleY >= 0)
    then begin
       if Length(RqArrXY) > 1
       then begin
          IndB := Low(RqArrXY);
          IndE := High(RqArrXY);
          //  
          try
            with WImg.Canvas do
            begin
               Pen.Color := RqColor;
               WPenX:= XtoL(RqArrXY[IndB].X);
               WPenY:= YtoT(RqArrXY[IndB].Y);
               MoveTo(WPenX,WPenY);
               for Ind := IndB + 1 to IndE do
               begin
                  with RqArrXY[Ind] do
                  begin
                     WPenX:= XtoL(X);
                     WPenY:= YtoT(Y);
                     LineTo(WPenX,WPenY);
                  end; {of with RqXY[Ind]}
               end; {of for Ind := IndB}
            end; {of with WImg.Canvas}
            //     
            StTxtImg.Color := RqColor;
          except
             ShowMessage('TGraphXY :    ');
          end;
       end
       else ShowMessage('TGraphXY :     ');
    end
    else ShowMessage('TGraphXY :    ');
  end
  else ShowMessage('TGraphXY :    ');
end;
// ---------------------------------------------------------------------------
// 19.05.2015 -     X
//  X -       X
procedure TGraphXY.CalcRangeAndScaleX();
const eps = 1e-100;
begin
   fXLRange := 0;                    //  
   if (fXMax > fXMin) and (Abs(fXMax - fXMin) > eps)
   then begin
      fXRMin     := fXMin;          // X - Min   
      fXRMax     := fXMax;          // X - Max   
      fXLRange   := Abs(fXRMax - fXRMin);
      fScaleX    := (WImg.Width -1)/fXLRange;
      //     
      if (fXRMax > 0) and (fXRMin < 0)
      then fBaseX := 0  //  
      else begin
         //      X
         if (fXRMin >= 0) and (fXRMax > 0)
         then fBaseX := fXRMin;
         //      X
         if (fXRMin < 0) and (fXRMax <= 0)
         then fBaseX := fXRMax;     // (Max  Min < 0
      end;
      fXforAxesY := fBaseX;         //   Y   X
   end;
   //     X
   if fXLRange > 0
   then fScaleX:= (WImg.Width -1)/fXLRange
   else begin
       fScaleX := 0;
       //       X
       MessageDlg('TGraphXY :   '
                + #13#10
                + '     X.',
                 mtError, [mbOk], 0);
   end;
end;
// ---------------------------------------------------------------------------
// 25.05.2015 -   fYMax = fYMin
// 12.04.2013 -      
// 19.05.2015 -      Abs(fYMax - fYMin)
//  Y -       Y
procedure TGraphXY.CalcRangeAndScaleY();
const eps = 1e-100;
begin
   if  Abs(fYMax - fYMin) < eps
   then begin
       //    Y
       if (Abs(fYMax) < eps) and (Abs(fYMin) < eps)
       then begin
          //      
          fYMax :=   10 * eps;
          fYMin := - 10 * eps;
          fYRMin     := fYMin;          // Y - Min   
          fYRMax     := fYMax;          // Y - Max   
          fYLRange   := Abs(fYRMax - fYRMin);
          fScaleY    := (WImg.Height -1)/fYLRange;
          fBaseY     := 0;
          fYforAxesX := 0;              //   X   Y
          fPicAxesY  := '%2.1e';        // Format-    Y
       end
       else begin
          //       
          if fYMax > 0
          then begin
              //  
              fYRMin   := 0;            // Y - Min   
              fYRMax   := 1.1 * fYMax;  // Y - Max   
              fYLRange := Abs(fYRMax);
              fBaseY   := fYRMin;
          end
          else begin
              //  
              fYRMin   := 1.1 * fYMin;  // Y - Min   
              fYRMax   := 0;            // Y - Max   
              fYLRange := Abs(fYRMin);
              fBaseY   := fYRMax;
          end;
        end;
        //    
        if fYLRange > 0
        then begin
             fScaleY  := (WImg.Height -1)/fYLRange;
             fYforAxesX := fBaseY;        //   X   Y
        end     
        else begin
           fScaleY  := 0;
           ShowMessage('GraphXY :       Y');
        end;
   end
   else begin
      //    Y
      fYRMin     := fYMin;          // Y - Min   
      fYRMax     := fYMax;          // Y - Max   
      fYLRange   := Abs(fYRMax - fYRMin);
      fScaleY    := (WImg.Height -1)/fYLRange;
      //     
      if (fYRMax > 0) and (fYRMin < 0)
      then fBaseY := 0  //  
      else begin
         //      Y
         if (fYRMin >= 0) and (fYRMax > 0)
         then fBaseY := fYRMin;
         //      Y
         if (fYRMin < 0) and (fYRMax <= 0)
         then fBaseY := fYRMax;     // (Max  Min < 0
      end;
      fYforAxesX := fBaseY;         //   X   Y
   end;
end;
// ---------------------------------------------------------------------------
// 25.05.2013
//        
procedure TGraphXY.CalculateScale();
begin
   //     
   CalcRangeAndScaleX();
   CalcRangeAndScaleY();
end;
// ---------------------------------------------------------------------------
// 25.05.2013
//      
procedure TGraphXY.ShowGridLine();
begin
    ShowHGridAndAxesY();
    ShowHGridAndAxesX();
end;
// ---------------------------------------------------------------------------
// 25.05.2013 / 22.09.2014 ()
//    
procedure TGraphXY.EraseAreaXY();
begin
  //  
  HideRuler();
  with WImg.Canvas do
  begin
     Brush.Color := fWImgColor;
     FillRect(Rect(0,0, WImg.Width, WImg.Height ));
  end;
end;
// ---------------------------------------------------------------------------
// 25.05.2013
//      GraphXY
procedure TGraphXY.PrepareAreaXY();
begin
  EraseAreaXY();
  if (fScaleX > 0) and (fScaleY > 0)
  then ShowGridLine();
end;
// ===========================================================================
//
//    GraphXY
//
// ===========================================================================
procedure TGraphXY.SetGraphTitul (GraphTitul : string);
begin
  fGraphTitul := GraphTitul;
  LabelImg.Font.Name := fRulFontNm;
  LabelImg.Font.Size := fRulFontSz;
  LabelImg.Caption := fGraphTitul;
end;
procedure TGraphXY.SetImgBackGroundColor (BackGroundColor : TColor);
begin
   fWImgColor := BackGroundColor;
   PrepareAreaXY();
end;
procedure TGraphXY.SetGridColor (GridColor : TColor);
begin
   fGridColor := GridColor;
   PrepareAreaXY();
end;
procedure TGraphXY.SetAxesColor (AxesColor : TColor);
begin
   fAxesColor := AxesColor;
   PrepareAreaXY();
end;
procedure TGraphXY.SetPicAxesX (PicAxesX : string);
begin
   fPicAxesX := PicAxesX;
   PrepareAreaXY();
end;
procedure TGraphXY.SetPicAxesY (PicAxesY : string);
begin
   fPicAxesY := PicAxesY;
   PrepareAreaXY();
end;

// ===========================================================================
//
//  PUBLIC -   GraphXY
//
// ===========================================================================
// 25.05.2013
//   /   X  Y,  
//        
procedure TGraphXY.SetScaleXY (RqScaleX,  RqScaleY : extended);
begin
  if not Assigned(WImg) then Exit;
  if (RqScaleX > 0) and (RqScaleY > 0)
  then begin
      fScaleX := RqScaleX;
      fScaleY := RqScaleY;
      fXMax :=  (WImg.Width / 2) / fScaleX;
      fXMin := - fXMax;
      fYMax :=  (WImg.Height / 2) / fScaleY;
      fYMin := - fYMax;
      PrepareAreaXY();
  end;
end; {of procedure SetScaleXY}
// ---------------------------------------------------------------------------
// 25.05.2013
//       
procedure TGraphXY.SetMinMaxXY (RqXMin, RqXMax, RqYMin, RqYMax: extended);
begin
  if not Assigned(WImg) then Exit;
  if (RqXMin < RqXMax)
  then begin
      fXMin := RqXMin;
      fXMax := RqXMax;
      fYMin := RqYMin;
      fYMax := RqYMax;
      CalculateScale();
      PrepareAreaXY();
  end
  else begin
       ShowMessage('TGraphXY : X-Min     X-Max!');
  end;
end;
// ---------------------------------------------------------------------------
// 23.05.2015 -       X  Y
//       
procedure TGraphXY.FindOptimalScale(RqArrXY : TGraphArr);
const TopValue  = 1e4000; //1e308;
var   Ind     : integer;
      FlTopX  : boolean;
      FlTopY  : boolean;
begin
  fScaleX:=0;   //  
  fScaleY:=0;   //  
  // 
  if not Assigned(WImg) then Exit;
  //    
  if Assigned(RqArrXY)
  then begin
    //   
    if Length(RqArrXY) > 1
    then begin
       FlTopX := False;
       FlTopY := False;
       for Ind := Low(RqArrXY) to High(RqArrXY)
       do begin
          //        X
          if (Abs(RqArrXY[Ind].X) > TopValue)
          then begin
             FlTopX := True;
             if RqArrXY[Ind].X > 0
             then RqArrXY[Ind].X := TopValue
             else RqArrXY[Ind].X := -TopValue;
          end;
          //        Y
          if (Abs(RqArrXY[Ind].Y) > TopValue)
          then begin
             FlTopY := True;
             if RqArrXY[Ind].Y > 0
             then RqArrXY[Ind].Y := TopValue
             else RqArrXY[Ind].Y := -TopValue;
          end;
          //      X  Y
          with RqArrXY[Ind] do
          begin
             if Ind = Low(RqArrXY)
             then begin
                 fXMin := X;
                 fXMax := fXMin;
                 fYMin := Y;
                 fYMax := fYMin;
             end
             else begin
                 if X < fXMin then fXMin := X;
                 if X > fXMax then fXMax := X;
                 if Y < fYMin then fYMin := Y;
                 if Y > fYMax then fYMax := Y;
             end;
          end;
       end;
       if RqArrXY[Low(RqArrXY)].X < RqArrXY[High(RqArrXY)].X
       then begin
          //    
          CalculateScale();
          PrepareAreaXY();
          if FlTopX then MessageDlg(fGraphTitul + ':'
                       + #13#10
                       + '    '
                       + #13#10
                       + '    '
                       + #13#10
                       + '  .',
                       mtInformation, [mbOk], 0);
          if FlTopY then MessageDlg(fGraphTitul + ':'
                       + #13#10
                       + '    Y'
                       + #13#10
                       + '    '
                       + #13#10
                       + '  ' + FloatToStr(TopValue),
                       mtInformation, [mbOk], 0);
       end
       else begin
          MessageDlg(fGraphTitul + ':'
                     + #13#10
                     + '     X'
                     + #13#10
                     + '  ...',
                     mtError, [mbOk], 0);
       end;
    end
    else MessageDlg(fGraphTitul + ':'
                   + #13#10
                   + '    '
                   + #13#10
                   + '  ...',
                   mtError, [mbOk], 0);
  end
  else MessageDlg(fGraphTitul + ':'
                 + #13#10
                 + '    '
                 + #13#10
                 + '  ...',
                 mtError, [mbOk], 0);
end;
// ---------------------------------------------------------------------------
//       
procedure TGraphXY.ShowGraphXY (RqArrXY : TGraphArr; RqColor : TColor);
begin
  if not Assigned(WImg) then Exit;
  if Assigned(RqArrXY)
  then begin
     //      
     //      
     if not ((fScaleX > 0) and (fScaleY > 0))
     then FindOptimalScale(RqArrXY);
     //       
     if (fScaleX > 0) and (fScaleY > 0)
     then PaintGraphXY (RqArrXY, RqColor)
     else ShowMessage('TGraphXY :      ');
  end
  else ShowMessage('TGraphXY :    ');
end;
// ---------------------------------------------------------------------------
//        (RqX, RqY)
procedure TGraphXY.SubscriptPointXY(RqX, RqY : extended; RqColor : TColor; RqText : string);
var   WLeft, WTop : longint;
begin
  if not Assigned(WImg) then Exit;
  if (fScaleX > 0) and (fScaleY > 0)
  then begin
     WLeft:= XtoL(RqX);
     WTop:= YtoT(RqY);
     SubscriptPointLT(WLeft, WTop, RqColor, RqText);
  end
  else begin
     ShowMessage('TGraphXY.SubscriptPointXY :    ');
  end;
end; {of procedure SubscriptPoint}
// ---------------------------------------------------------------------------
//   (  )      (RqX, RqY)
procedure TGraphXY.PaintPointXY(RqX, RqY : extended; RqColor : TColor; RqRadius : byte);
var   WLeft, WTop : longint;
      SaveStyle   : TBrushStyle;
      SaveColor   : TColor;
begin
  if not Assigned(WImg) then Exit;
  if (fScaleX > 0) and (fScaleY > 0) and (RqRadius > 0)
  then begin
     WLeft:= XtoL(RqX);
     WTop:= YtoT(RqY);
     //  
     with WImg.Canvas do
     begin
        SaveStyle   := Brush.Style;
        SaveColor   := Brush.Color;
        Brush.Color := RqColor;
        Brush.Style := bsSolid;
        Ellipse(WLeft - RqRadius, WTop - RqRadius, WLeft + RqRadius, WTop + RqRadius);
        Brush.Style := SaveStyle;
        Brush.Color := SaveColor;
     end;
  end
  else begin
     ShowMessage('TGraphXY.PaintPointXY :    ');
  end;
end; {of procedure PaintPointXY}
// ---------------------------------------------------------------------------
//    X,Y -    
procedure TGraphXY.VectotToGraphXY(XB, YB, XE, YE : extended; RqColor : TColor);
var WPenX, WPenY : longint;
begin
   if not Assigned(WImg) then Exit;
   if (fScaleX > 0) and (fScaleY > 0)
   then begin
      with WImg.Canvas do
      begin
         Pen.Color := RqColor;
         WPenX:= XtoL(XB);
         WPenY:= YtoT(YB);
         MoveTo(WPenX,WPenY);
         WPenX:= XtoL(XE);
         WPenY:= YtoT(YE);
         LineTo(WPenX,WPenY);
      end; {of with WImg.Canvas}
      PaintPointXY(XE, YE, RqColor, 2);
   end;
end; {of procedure VectotToGraphXY}
// ---------------------------------------------------------------------------
//      
procedure TGraphXY.FullEraseAreaXY();
begin
    if not Assigned(WImg) then Exit;
    //   
    fXMin := 0;
    fXMax := 0;
    fYMin := 0;
    fYMax := 0;
    //-----------
    fXRMin := 0;
    fXRMax := 0;
    fYRMin := 0;
    fYRMax := 0;
    // ----------
    fXLRange := 0;
    fYLRange := 0;
    // ----------
    fScaleX:=0;
    fScaleY:=0;
    //  
    EraseAreaXY();
end; {of procedure FullEraseAreaXY}
// ---------------------------------------------------------------------------
//     . (RqGFormat: 'J' - jpg   'B' -bmp)
procedure TGraphXY.SaveGraphXY(RqFullFileName : string; RqGFormat : char);
var  wPath, wName, wExt, wFileName : string;
     wPPos  : word;
     wOK    : boolean;
var  Jpeg   : TJPEGImage;  //   unit jpeg.
     BitMap : TBitMap;
begin
   if not Assigned(WImg) then Exit;
   wOK   := False;
   wPath := ExtractFilePath(RqFullFileName);  //  'Disk:\dir1\..\DirN\'
   wName := ExtractFileName(RqFullFileName);  //  'Name.Ext'  ''
   WExt  := ExtractFileExt(wName);            //  '.Ext'  ''
   if Length(WExt) > 0
   then begin
       //   
       wPPos := Pos('.', wName);
       if (wPPos > 1)
       then begin
            wName := LeftStr(wName,wPPos-1);
            wFileName := wPath + wName;
            wOK := True;
       end;
   end
   else begin
       //     ( )
       wFileName := wPath + wName;
       wOK := True;
   end;
   if WOk
   then begin
       case UpCase(RqGFormat) of
       // ==========================
       'J' : begin      //   Jpeg
               wFileName := wFileName + '.jpg';
               Jpeg := TJPEGImage.Create;
               try
                  with Jpeg do
                  begin            //  Bitmap  JPG
                     Assign(WImg.Picture.Bitmap);
                     SaveToFile(wFileName);
                  end;
               finally
                     Jpeg.Free;    //   JPG
               end;
             end;
          // ==========================
         'B': begin       //   BMP
                wFileName := wFileName + '.bmp';
                BitMap := TBitMap.Create;
                try
                   with BitMap do   //  Bitmap  BMP
                   begin
                      Assign(WImg.Picture.Bitmap);
                      SaveToFile(wFileName);
                   end;
                finally
                      BitMap.Free;  //   BMP
                end;
              end;
       end; {of case}
   end;
end; {of procedure SaveGraphXY}

// ===========================================================================
//
//      GraphXY
//
// ===========================================================================
// 22.09.2014 ()
//      
procedure TGraphXY.OpenGraphXY(RqPanel: TPanel);
begin
  if (RqPanel.Width > (Border1Left + Border1Right + MinWidth)) and
     (RqPanel.Height > (Border1Up + Border1Down + MinHeight))
  then begin
      //   
      // =============================
      //   
      // =============================
      //     Image
      BevelWImg  := TBevel.Create(RqPanel);
      BevelWImg.Parent := RqPanel;
      with BevelWImg do
      begin
         Name    := 'BevelWImgXY';
         Shape   := bsBox;
         Top     := Border1Up;
         Left    := Border1Left;
         Width   := RqPanel.Width  - (Border1Left + Border1Right);
         Height  := RqPanel.Height - (Border1Up + Border1Down);
         Visible := True;
         ControlStyle := [csClickEvents];
      end;
      //   Image
      WImg := TImage.Create(RqPanel);
      WImg.Parent := RqPanel;
      with WImg do
      begin
        Name    := 'WImgXY';
        Top     := Border1Up + 4;
        Left    := Border1Left + 4;
        Width   := RqPanel.Width - (Border1Left + Border1Right + 8);
        Height  := RqPanel.Height -(Border1Up + Border1Down + 8);
        Visible := True;
        // ------------------------
        //    
        OnMouseMove := MouseMove;
        OnMouseDown := MouseDown;
        OnMouseUp   := MouseUp;
        Enabled     := True;    //    WImg
      end;
      //    
      StTxtImg   := TStaticText.Create(RqPanel);
      StTxtImg.Parent  := RqPanel;
      with StTxtImg do
      begin
         Name     := 'StTxtWImgXY';
         Top      := LabelTop + 1;
         Left     := Border1Left;
         AutoSize := False;
         Height   := 12;
         Width    := 12;
         BorderStyle := sbsSunken;
         Caption := '';
         Visible  := True;
      end;
      //     Image
      LabelImg   := TLabel.Create(RqPanel);
      LabelImg.Parent := RqPanel;
      with LabelImg do
      begin
         Name     := 'LabelWImgXY';
         Top      := LabelTop;
         Left     := Border1Left + 16;
         AutoSize := True;
         Caption  := '    ';
         Visible  := True;
      end;
  end;
end;
// ---------------------------------------------------------------------------
//      
procedure TGraphXY.CloseGraphXY();
var Parent : TWinControl;
begin
   //    
   Parent := WImg.Parent;
   //    
   StTxtImg.Free;
   LabelImg.Free;
   BevelWImg.Free;
   WImg.Free;
   //   
   Parent.Repaint;
end;
// ---------------------------------------------------------------------------
// 22.09.2014 ()
constructor TGraphXY.Create(RqPanel: TPanel);
begin
   inherited Create;
   fPanel := RqPanel;
   WImg   := nil;
   // -----------------------------
   OpenGraphXY(fPanel);             //   
   // -----------------------------
   //   
   fRulEn     := True;              //  
   fRulOn     := False;             //    
   fRulMov    := False;             //      
   //       fWImgColor
   fRulColor  := RGB(255, 127, 0);  //   
   fRulMode   := False;             //    
   // -----------------------------
   //   
   fScaleX :=0;                     //  X   
   fScaleY :=0;                     //  Y   
   // -----------------------------
   //    
   fWImgColor := clWindow;          //   
   fWImgFont   := RqPanel.Font;     //    
   // -----------------------------
   fAxesToZero := True;              //     
   fAxesColor  := clBlack;           //     
   fPicAxesX   := '%-0.2f';          // Format-    X
   fPicAxesY   := '%-0.2f';          // Format-    Y
   // -----------------------------
   fNumXCrid   := 10;                //     
   fNumYCrid   := 10;                //     Y
   fGridColor  := RGB(128,128,128);  //   
   // -----------------------------
   fRulFontNm  := 'MS Sans Serif';   //     
   fRulFontSz  := 8;                 //     
   // -----------------------------
   EraseAreaXY();                    //   
   // -----------------------------
   fEnabled   := True;               //   
end;
// ---------------------------------------------------------------------------
procedure TGraphXY.Free();
begin
   CloseGraphXY();
   inherited Free;
end;

// ===========================================================================
// ===========================================================================
// ===========================================================================
end.
